# -*- coding: utf-8 -*-
from enigma import getDesktop

from Components.Label import Label
from Components.ActionMap import ActionMap
from Components.Sources.List import List 
from Components.PluginList import resolveFilename 

from Screens.MessageBox import MessageBox
from Screens.Screen import Screen

from Tools.LoadPixmap import LoadPixmap
from Tools.Directories import fileExists, SCOPE_PLUGINS
		
from Plugins.Plugin import PluginDescriptor

from utils import reloadChannelList, CommonChannelListScreen, Djcrash, CommonPiconListScreen


version = "2.3 17.02.2018"

class ChannelListUpdateMenu(Screen):
	skin = '''<screen name="ChannelListUpdateMenu" position="center,center" size="750,460" title="Polskie listy kanałów" >
			<widget source="list" render="Listbox" position="10,10" size="730,240" scrollbarMode="showOnDemand" transparent="1">
				<convert type="TemplatedMultiContent">
				{"template": [
					MultiContentEntryText(pos = (115, 2), size = (620, 26), font=0, color=0x3589ff, flags = RT_HALIGN_LEFT, text = 0),
					MultiContentEntryPixmapAlphaBlend(pos = (2, 5), size = (100, 40), png = 1),
					MultiContentEntryText(pos = (115, 30), size = (620, 26), font=1, flags = RT_VALIGN_TOP | RT_HALIGN_LEFT, text = 3),
					],
					"fonts": [gFont("Regular", 24),gFont("Regular", 22)],
					"itemHeight": 60
				}
				</convert>
			</widget>
			<widget name="info" position="5,280" size="740,180" font="Regular;28" halign="center" backgroundColor="#193e"/>
		  </screen>'''
		  
	def __init__(self, session):
		Screen.__init__(self, session)
		self.list = []
		self["list"] = List(self.list)
		
		self.updateList()
		
		self["info"] = Label("Plugin do aktualizacji list kanałów by Rango edycja enigma2.pl - %s" % version)
		self["actions"] = ActionMap(["WizardActions", "ColorActions"], {"ok": self.KeyOk, "back": self.close})
		
	def KeyOk(self):
		self.sel = self["list"].getCurrent()
		returnValue = self.sel[2]
		if returnValue is "richter":
				self.session.open(Ritcher)
		elif returnValue is "bzyk83":
				self.session.open(bzyk83)
		elif returnValue is "djcrash":
				self.session.open(Djcrash)
		elif returnValue is "k80":
				self.session.open(K80)
		elif returnValue is "fk":
				self.session.open(Fk)
		elif returnValue is "master":
				self.session.open(Master)
		elif returnValue is "enigma2_pl":
			  self.session.open(enigma2_pl)

	def updateList(self):
		self.list = []
		mypath = resolveFilename(SCOPE_PLUGINS)
		mypath = mypath + "Extensions/RangoPolishChannelsUpdater/images/"

		mypixmap = (mypath + "richter.png")
		png = LoadPixmap(mypixmap)
		name = (_("Pobierz listę od Richtera"))
		desc = (_("Listy dla HotBird 13.0E oraz Astra 19.2E"))
		idx = "richter"
		res = (name,png,idx,desc)
		self.list.append(res)

		mypixmap = (mypath + "bzyk83.png")
		png = LoadPixmap(mypixmap)
		name = (_("Pobierz listę od bzyk83"))
		desc = (_("Lista dla HotBird 13.0E oraz Astra 19.2E"))
		idx = "bzyk83"
		res = (name,png,idx,desc)
		self.list.append(res)
		
		mypixmap = (mypath + "djcrash.png")
		png = LoadPixmap(mypixmap)
		name = (_("Pobierz listę od DjCrasha"))
		desc = (_("Listy dla HotBird 13.0E, 19.2E, 23,5E, 28,2E oraz obrotnica"))
		idx = "djcrash"
		res = (name,png,idx,desc)
		self.list.append(res)

		mypixmap = (mypath + "k80.png")
		png = LoadPixmap(mypixmap)
		name = (_("Pobierz listę od Krzysiek80"))
		desc = (_("Listy dla HotBird 13.0E"))
		idx = "k80"
		res = (name,png,idx,desc)
		self.list.append(res)

		mypixmap = (mypath + "fk.png")
		png = LoadPixmap(mypixmap)
		name = (_("Pobierz listę od fullkiller™"))
		desc = (_("Listy dla HotBird 13.0E"))
		idx = "fk"
		res = (name,png,idx,desc)
		self.list.append(res)
		
		mypixmap = (mypath + "master.png")
		png = LoadPixmap(mypixmap)
		name = (_("Pobierz listę od Mastera"))
		desc = (_("Listy dla HotBird 13.0E oraz Astra 19.2E"))
		idx = "master"
		res = (name,png,idx,desc)
		self.list.append(res)
	
		mypixmap = (mypath + "enigma2.png")
		png = LoadPixmap(mypixmap)
		name = (_("Pobierz listę od enigma2.pl"))
		desc = (_("Lista dla HotBird 13.0E"))
		idx = "enigma2_pl"
		res = (name,png,idx,desc)
		self.list.append(res)

		self["list"].list = self.list

	def quit(self):
		self.close()

class Ritcher(CommonChannelListScreen):
	def __init__(self, session, args = None):
		Screen.__init__(self, session)
		CommonChannelListScreen.__init__(self, session)
		self.url1 = 'http://areq.eu.org/richter/latest1x'
		self.url2 = 'http://areq.eu.org/richter/latest2x'
		
		self.reloadUrlList()
		
		Screen.setTitle(self, _("Listy kanałów Richter - zainstalowana wersja: " + self.channelListVersion))

class bzyk83(CommonChannelListScreen):
	def __init__(self, session, args = None):
		Screen.__init__(self, session)
		CommonChannelListScreen.__init__(self, session)
		
		self.url1 = 'http://enigma2.pl/lista_bzyk83/latest1x'
		self.url2 = 'http://enigma2.pl/lista_bzyk83/latest2x'
		
		self.reloadUrlList()
		
		Screen.setTitle(self, _("Listy kanałów bzyk83 - zainstalowana wersja: " + self.channelListVersion))

class K80(CommonChannelListScreen):
	def __init__(self, session, args = None):
		Screen.__init__(self, session)
		CommonChannelListScreen.__init__(self, session)
		
		self.url1 = 'http://egami-feed.com/plugins/listy/k80/latest1x.txt'
		self.url2 = 'http://egami-feed.com/plugins/listy/k80/latest2x.txt'
		
		self.reloadUrlList()
		
		Screen.setTitle(self, _("Listy kanałów K80 - zainstalowana wersja: " + self.channelListVersion))

class Fk(CommonChannelListScreen):
	def __init__(self, session, args = None):
		Screen.__init__(self, session)
		CommonChannelListScreen.__init__(self, session)
		
		self.url1 = 'http://egami-feed.com/plugins/listy/fk/latest1x.txt'
		self.url2 = 'http://egami-feed.com/plugins/listy/fk/latest2x.txt'
		
		self.reloadUrlList()
		
		Screen.setTitle(self, _("Listy kanałów Fk - zainstalowana wersja: " + self.channelListVersion))
		
class Master(CommonChannelListScreen):
	def __init__(self, session, args = None):
		Screen.__init__(self, session)
		CommonChannelListScreen.__init__(self, session)
		
		self.url1 = 'http://egami-feed.com/plugins/listy/master/latest1x.txt'
		self.url2 = 'http://egami-feed.com/plugins/listy/master/latest2x.txt'
		
		self.reloadUrlList()
		
		Screen.setTitle(self, _("Listy kanałów MASTER - zainstalowana wersja: " + self.channelListVersion))		

class enigma2_pl(CommonChannelListScreen):
	def __init__(self, session, args = None):
		Screen.__init__(self, session)
		CommonChannelListScreen.__init__(self, session)
		
		self.url1 = 'http://enigma2.pl/lista/latest1x.txt'
		
		self.reloadUrlList()
		
		Screen.setTitle(self, _("Listy kanałów enigma2.pl - zainstalowana wersja: " + self.channelListVersion))
		
def main(session, **kwargs):
	session.open(ChannelListUpdateMenu)

def menu(menuid, **kwargs):
	if menuid == "scan":
		return [(_("Polskie listy kanałów"), main, "egami_channellist", 1)]
	return []  

	      
def Plugins(**kwargs):
	screenwidth = getDesktop(0).size().width()
	if screenwidth and screenwidth == 1920:  
		return [
			PluginDescriptor(name = "Polskie listy kanałów", description=_('Najnowsza kolekcja polskich list kanałów'), where = PluginDescriptor.WHERE_MENU, fnc = menu),
			PluginDescriptor(name = "Polskie listy kanałów", description=_('Najnowsza kolekcja polskich list kanałów'), icon='pluginhd.png', where=PluginDescriptor.WHERE_PLUGINMENU, fnc=main)
		]
	else:
		return [
			PluginDescriptor(name = "Polskie listy kanałów", description=_('Najnowsza kolekcja polskich list kanałów'), where = PluginDescriptor.WHERE_MENU, fnc = menu),
			PluginDescriptor(name = "Polskie listy kanałów", description=_('Najnowsza kolekcja polskich list kanałów'), icon='plugin.png', where=PluginDescriptor.WHERE_PLUGINMENU, fnc=main)
		]